/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.tab;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.MekanismAPI;
import mekanism.api.security.ISecurityObject;
import mekanism.api.security.SecurityMode;
import mekanism.api.text.EnumColor;
import mekanism.client.SpecialColors;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInsetElement;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.lib.security.SecurityData;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.network.to_server.PacketSecurityMode;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.text.OwnerDisplay;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;

public class GuiSecurityTab
extends GuiInsetElement<Supplier<ICapabilityProvider>> {
    private static final ResourceLocation PUBLIC = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "public.png");
    private static final ResourceLocation PRIVATE = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "private.png");
    private static final ResourceLocation PROTECTED = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "protected.png");
    @Nullable
    private final InteractionHand currentHand;

    public GuiSecurityTab(IGuiWrapper gui, ICapabilityProvider provider) {
        this(gui, provider, 34);
    }

    public GuiSecurityTab(IGuiWrapper gui, ICapabilityProvider provider, int y) {
        this(gui, () -> provider, y, null);
    }

    public GuiSecurityTab(IGuiWrapper gui, @Nonnull InteractionHand hand) {
        this(gui, () -> GuiSecurityTab.minecraft.f_91074_.m_21120_(hand), 34, hand);
    }

    private GuiSecurityTab(IGuiWrapper gui, Supplier<ICapabilityProvider> provider, int y, @Nullable InteractionHand hand) {
        super(PUBLIC, gui, provider, gui.getWidth(), y, 26, 18, false);
        this.currentHand = hand;
    }

    @Override
    protected void colorTab() {
        MekanismRenderer.color(SpecialColors.TAB_SECURITY);
    }

    @Override
    protected ResourceLocation getOverlay() {
        return switch (MekanismAPI.getSecurityUtils().getSecurityMode((ICapabilityProvider)((Supplier)this.dataSource).get(), true)) {
            default -> throw new IncompatibleClassChangeError();
            case SecurityMode.PUBLIC -> super.getOverlay();
            case SecurityMode.PRIVATE -> PRIVATE;
            case SecurityMode.TRUSTED -> PROTECTED;
        };
    }

    @Override
    public void m_7428_(@Nonnull PoseStack matrix, int mouseX, int mouseY) {
        super.m_7428_(matrix, mouseX, mouseY);
        ICapabilityProvider provider = (ICapabilityProvider)((Supplier)this.dataSource).get();
        if (provider != null) {
            provider.getCapability(Capabilities.SECURITY_OBJECT).ifPresent(security -> {
                SecurityData data = SecurityUtils.INSTANCE.getFinalData((ISecurityObject)security, true);
                MutableComponent securityComponent = MekanismLang.SECURITY.translateColored(EnumColor.GRAY, data.mode());
                Component ownerComponent = OwnerDisplay.of((Player)GuiSecurityTab.minecraft.f_91074_, security.getOwnerUUID(), security.getOwnerName()).getTextComponent();
                if (data.override()) {
                    this.displayTooltips(matrix, mouseX, mouseY, new Component[]{securityComponent, ownerComponent, MekanismLang.SECURITY_OVERRIDDEN.translateColored(EnumColor.RED, new Object[0])});
                } else {
                    this.displayTooltips(matrix, mouseX, mouseY, new Component[]{securityComponent, ownerComponent});
                }
            });
        }
    }

    public void m_5716_(double mouseX, double mouseY) {
        ICapabilityProvider provider = (ICapabilityProvider)((Supplier)this.dataSource).get();
        if (provider != null) {
            provider.getCapability(Capabilities.SECURITY_OBJECT).ifPresent(security -> {
                if (security.ownerMatches((Player)GuiSecurityTab.minecraft.f_91074_)) {
                    if (this.currentHand != null) {
                        Mekanism.packetHandler().sendToServer(new PacketSecurityMode(this.currentHand));
                    } else if (provider instanceof BlockEntity) {
                        BlockEntity tile = (BlockEntity)provider;
                        Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.NEXT_SECURITY_MODE, tile));
                    } else if (provider instanceof Entity) {
                        Entity entity = (Entity)provider;
                        Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteractionEntity.NEXT_SECURITY_MODE, entity));
                    }
                }
            });
        }
    }
}

